### 1. Overview: Security Events & Alarms

- Secure Network Analytics (SNA) analyzes network flow data using built-in security algorithms called security events.
- Security events assign index points to hosts, contributing to high-level alarm categories.
- Alarms notify analysts when suspicious or abnormal behavior is detected.

---

### 2. Indexes: Tracking Anomalous Host Behavior

- **Indexes** track hosts’ suspicious activities and trigger alarms when thresholds are met.
    - **Concern Index (CI):** Flags hosts exhibiting potentially compromising activities.
    - **Target Index (TI):** Flags hosts that appear to be victims of suspicious behavior.
    - **File Sharing Index (FSI):** Tracks peer-to-peer behavior.
- **Index Points:**
    - Accumulate based on security events.
    - Ranges from zero to thousands/hundreds of thousands.
    - Rolling average; trigger alarms when exceeding thresholds.
- **Alarm Categories:**
    - Group related security events (e.g., Command & Control (C&C)).
    - Alarm triggers when the tolerance/threshold for a category is exceeded.

---

### 3. Types of Security Events

- **Behavior-based Events**
    
    - Triggered by significant deviation from a host’s past behavior.
    - Sensitivity (tolerance) adjustable via policy management.
    - Uses recent activity baselines and configured thresholds.
    - Higher tolerance = fewer alarms; lower tolerance = more alarms.
- **Condition-based Events**
    
    - Triggered only if all specific conditions are met.
    - On/off setting; no sensitivity adjustment.
    - Example: Worm activity (multiple subnets scanned, connection established, info transferred).
- **Threshold/Duration-based Events**
    
    - Triggered by static minimum/maximum thresholds or duration.

---

### 4. Security Event Examples

- Approx. 100 security events, including:
    - Beaconing Host
    - Bot Infected Host—Attempted/Successful C&C Activity
    - Brute Force Login
    - Connection from Bogon Address
    - Flow_Denied
    - High Total Traffic
    - Host Lock Violation
    - Ping_Scan, UDP_Scan
    - Fake Application Detected (e.g., SSH on TCP port 80)

---

### 5. Alarms

- **Generation:** Result from security events breaching set thresholds.
    
- **Severity & Color Codes:**
    
    - Critical: Red
    - Major: Orange
    - Minor: Yellow
    - Trivial: Blue
    - Informational: Light Blue
    - No Alarms: Green
- **Access:** Alarm info available via WebUI & Desktop Client.
    
- **Examples:**
    
    - Data Hoarding: Unusual data download/upload volume.
    - Recon: Unauthorized scanning (e.g., port scan, address scan).

---

### 6. Baselines & Anomaly Detection

- **Baselining:** SNA creates a profile of normal behavior for hosts/groups.
- **Calculation:** Weighted average of recent daily max values, plus previous three weeks’ same-day max.
- **Behavioral Anomaly Detection:** Triggers alarms when deviations from baseline are observed.
- **Custom Policies:** Allow for business-specific anomaly detection (e.g., data transfer limits by country and business hours).

---

### 7. Alarm Visualization & Dashboards

- **WebUI Dashboard:**
    - Shows alarm categories, affected hosts, severity, and types.
    - Visual widgets display alarm volumes and active alarms for the day.
    - Interactive charts provide historical alarm data for analysis.

---

### 8. Converged Analytics (from v7.3.2+)

- **Enhanced Analytics Engine:**
    
    - Uses Dynamic Entity Modeling (machine learning).
    - Works without tuning host groups or configuring policies.
    - Consumes more system resources.
- **Core Concepts:**
    
    - **Entities:** Network elements (hosts/endpoints) tracked over time.
    - **Roles:** Functions/behaviors of entities (e.g., email server, workstation).
    - **Observations:** Factual behavior records (e.g., “External Port Scanner”).
    - **Alerts:** Actionable notifications mapped to MITRE ATT&CK Framework.
- **Example:**
    
    - “Geographically Unusual Remote Access” alert for access from unexpected countries.

---

### 9. Notes & Considerations

- **Some security events may directly trigger alarms or not be linked to any index/alarm category.**
- **Baseline accuracy improves over four weeks of data collection.**
- **Converged Analytics is optional and requires a Data Store deployment.**

---

### Example Scenario

- **Recon Alarm:** Host 10.201.3.149 triggers a Recon alarm after accumulating 1.62M points (policy allows 100,000), due to multiple TCP scans.